<?php
/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 9.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_account_navigation' );
?>

<nav id="main-nav" class="woocommerce-MyAccount-navigation col-4 col-lg-2">
	<section  class="br_profile-avatar ">
		<header>
			<div class="profile_img">
			<?php 
				if ( is_user_logged_in() ) {
					$current_user = wp_get_current_user();
					if ( ($current_user instanceof WP_User) ) {
						echo get_avatar( $current_user->ID, 96 );
						echo '<span>' . esc_html( $current_user->display_name ) . '</span>';
					}
				}
			?>
			</div>
		</header>
		<footer>
		</footer>
	</section>
	<ul>
		<?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
			<li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
				<a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
			</li>
		<?php endforeach;
		if(function_exists('dokan')){ ?>
		<li class="dokan_dashboard_btn">
		<?php echo dokan_dashboard_btn(); ?>
		</li>
		<?php } ?>
		<li class="woocommerce-MyAccount-navigation-link--customer-logout">
			<a href="<?php echo wc_get_account_endpoint_url( 'customer-logout' ); ?>"><?php _e( 'Exit', 'liosa' ); ?></a>
		</li>
	</ul>
	<p class="my-copyright">
	Copyright &copy; <?php echo date('Y'); echo  ' ';  echo bloginfo('name'); ?>
	</p>
</nav>

<?php do_action( 'woocommerce_after_account_navigation' ); ?>
