<?php
add_action('init', 'custom_theme_options');
function custom_theme_options()
{

	// OptionTree is not loaded yet, or this is not an admin request.
	if (!function_exists('ot_settings_id') || !is_admin()) {
		return false;
	}

	// Get a copy of the saved settings array.
	$saved_settings = get_option(ot_settings_id(), array());

	// Custom settings array that will eventually be passes to the OptionTree Settings API Class.
	$custom_settings = array(
		'contextual_help' => array(
			'sidebar' => '',
		),
		'sections'        => array(
			array(
				'id'    => 'general',
				'title' => esc_html__('general', 'liosa'),
			),
			array(
				'id'    => 'logo_barsa',
				'title' => esc_html__('logo', 'liosa'),
			),
			array(
				'id'    => 'header',
				'title' => esc_html__('header', 'liosa'),
			),
			array(
				'id'    => 'post_single',
				'title' => esc_html__('نوشته ها', 'liosa'),
			),
			array(
				'id'    => 'footer_blog',
				'title' => esc_html__('فوتر', 'liosa'),
			),
			array(
				'id'    => 'search',
				'title' => esc_html__('جستجو', 'liosa'),
			),
			array(
				'id'    => 'read_more',
				'title' => esc_html__('بیشتر بخوانید', 'liosa'),
			),
			array(
				'id'    => 'product_single',
				'title' => esc_html__('محصول', 'liosa'),
			),
			array(
				'id'    => 'back_to_top',
				'title' => esc_html__('بازگشت به بالا', 'liosa'), 
			),
			array(
				'id'    => 'profile_user',
				'title' => esc_html__('profile user', 'liosa'),
			),
			array( 
				'id'    => 'advertising',
				'title' => esc_html__('تبلیغات', 'liosa'),
			),
			array(
				'id'    => 'social_network',
				'title' => esc_html__('شبکه اجتماعی', 'liosa'),
			),
			array(
				'id'    => 'advanced',
				'title' => esc_html__('Advanced', 'liosa'),
			),
		),
		'settings'        => array(
			array(
				'id'           => 'background_body_blog',
				'label'        => esc_html__('Blog background', 'liosa'),
				'desc'         => esc_html__('', 'liosa'),
				'std'          => '',
				'type'         => 'background',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_classic',
				'label'        => 'انتخاب ویرایشگر ابزارک',
				'desc'         => 'انتخاب استایل و ویرایشگر ابزارک ها بصورت ، کلاسیک و گوتنبرگ',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'classic',
						'label' => 'کلاسیک',
						'src'   => '',
					),
					array(
						'value' => 'gutenberg',
						'label' => 'گوتنبرگ',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'select_tp_dowm_widget_mobile',
				'label'        => 'انتخاب ابزارک موبایل',
				'desc'         => 'انتخاب ابزارک مخصوص موبایل برای نمایش در پایین و بالای نوشته و محتوا',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'top',
						'label' => 'بالا',
						'src'   => '',
					),
					array(
						'value' => 'down',
						'label' => 'پایین',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'select_article',
				'label'        => 'انتخاب چیدمان آرشیو',
				'desc'         => 'انتخاب چیدمان آرشیو بصورت پیش فرض',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'article_1',
						'label' => 'چیدمان یک',
						'src'   => '',
					),
					array(
						'value' => 'article_2',
						'label' => 'چیدمان دو',
						'src'   => '',
					),
					array(
						'value' => 'article_3',
						'label' => 'چیدمان سه',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'show_arcive_popular',
				'label'        => esc_html__('نمایش مطالب پر بازدید', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن مطالب پربازدید در صفحه آرشیو', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'item_arcive_blog',
				'label'        => esc_html__('Number of blog archive items', 'liosa'),
				'desc'         => esc_html__('Number of blog archive items', 'liosa'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'general',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'logo_blog_barsa',
				'label'        => esc_html__('Blog logo', 'liosa'),
				'desc'         => esc_html__('Select a blog logo (100 * 50)', 'liosa'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'logo_barsa',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'logo_blog_header_4',
				'label'        => esc_html__('لوگو سربرگ چهار', 'liosa'),
				'desc'         => esc_html__('انتخاب لوگو سربرگ چهار (230*90)', 'liosa'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'logo_barsa',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'general_head',
				'label'        => esc_html__('عمومی', 'liosa'),
				'desc'         => esc_html__('عمومی', 'liosa'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_header',
				'label'        => 'انتخاب سربرگ',
				'desc'         => 'انتخاب سربرگ بصورت پیش فرض',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'header_nav_1',
						'label' => 'سربرگ یک',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_2',
						'label' => 'سربرگ دو',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_3',
						'label' => 'سربرگ سه',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_4',
						'label' => 'سربرگ چهار',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_5',
						'label' => 'سربرگ پنج',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_6',
						'label' => 'سربرگ شش',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'select_header_shop',
				'label'        => 'انتخاب سربرگ فروشگاه',
				'desc'         => 'انتخاب سربرگ بصورت پیش فرض فروشگاه',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'header_nav_1',
						'label' => 'سربرگ یک',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_2',
						'label' => 'سربرگ دو',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_3',
						'label' => 'سربرگ سه',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_4',
						'label' => 'سربرگ چهار',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_5',
						'label' => 'سربرگ پنج',
						'src'   => '',
					),
					array(
						'value' => 'header_nav_6',
						'label' => 'سربرگ شش',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'profile_header',
				'label'        => esc_html__('Show login button', 'liosa'),
				'desc'         => esc_html__('Show or hide the registration and login of the user in the header', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_search_header',
				'label'        => esc_html__('Show search button', 'liosa'),
				'desc'         => esc_html__('Show or hide the search box in the header', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_share_header',
				'label'        => esc_html__('دکمه اشتراک', 'liosa'),
				'desc'         => esc_html__('دکمه اشتراک را در سربرگ نشان داده یا پنهان کنید', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'head_mobile',
				'label'        => esc_html__('موبایل', 'liosa'),
				'desc'         => esc_html__('موبایل', 'liosa'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'profile_header_mobile',
				'label'        => esc_html__('Show login button', 'liosa'),
				'desc'         => esc_html__('Show or hide the registration and login of the user in the mobile', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'back_color_item_header',
				'label'        => esc_html__('پس زمینه ورود و ثبت نام', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه ورود و ثبت  نام در موبایل', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_item_brs',
				'label'        => esc_html__('رنگ آیکون ورود', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ ورود و ثبت  نام در موبایل', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_menu_mobile_b',
				'label'        => esc_html__('رنگ آیکون منو موبایل', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ ایکون منو موبایل ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_menu_mobile_text',
				'label'        => esc_html__('متن منو', 'liosa'),
				'desc'         => esc_html__('انتخاب متن منو موبایل', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_menu_mobile',
				'label'        => esc_html__('پس زمینه منو', 'liosa'),
				'desc'         => esc_html__('انتخاب پس زمینه منو موبایل', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'sub_menu_mobile',
				'label'        => esc_html__('پس زمینه زیر منو', 'liosa'),
				'desc'         => esc_html__('انتخاب پس زمینه زیر منو موبایل', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_border_line_mobile',
				'label'        => esc_html__('خط وسط', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ خط وسط ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_mobile',
				'label'        => esc_html__('موبایل فروشگاه', 'liosa'),
				'desc'         => esc_html__('موبایل فروشگاه', 'liosa'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_mobile',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_icon_mobile',
				'label'        => esc_html__('رنگ آیکون ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ آیکون سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'border_color_search_mobile',
				'label'        => esc_html__('حاشیه جستجو', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه جستجو', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_border_line_mobile_2',
				'label'        => esc_html__('خط وسط', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ خط وسط ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_radius_mobile',
				'label'        => esc_html__('گردی', 'liosa'),
				'desc'         => esc_html__('تنظیم گردی سربرگ موبایل', 'liosa'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'head_one',
				'label'        => esc_html__('سربرگ 1 و 2', 'liosa'),
				'desc'         => esc_html__('سربرگ 1 و 2', 'liosa'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show__menu_bar',
				'label'        => esc_html__('فعال کردن منوبار', 'liosa'),
				'desc'         => esc_html__('فعال /غیر فعال کردن منو بار ', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_background_blog',
				'label'        => esc_html__('Header background color', 'liosa'),
				'desc'         => esc_html__('Blog header background color', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_menu_blog',
				'label'        => esc_html__('Menu text color', 'liosa'),
				'desc'         => esc_html__('Menu text color', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_header_blog',
				'label'        => esc_html__('Icon colors', 'liosa'),
				'desc'         => esc_html__('Icon color in blog header', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'hover_background_text_menu',
				'label'        => esc_html__('Menu text background color hover', 'liosa'),
				'desc'         => esc_html__('Menu text background color hover', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_menubar',
				'label'        => esc_html__('رنگ پس زمینه منو بار', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو بار', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_menubar_share',
				'label'        => esc_html__('رنگ آیکون شبکه اجتماعی', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ آیکون شبکه اجتماعی منو بار ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'head_two',
				'label'        => esc_html__('سربرگ 3', 'liosa'),
				'desc'         => esc_html__('سربرگ 3', 'liosa'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_two',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'headershop_text_color_two',
				'label'        => esc_html__('رنگ متن سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_back_menu_hashtag',
				'label'        => esc_html__('رنگ پس زمینه منو', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو هشتگ در سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_menu_hashtag',
				'label'        => esc_html__('رنگ متن منو', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن منو هشتگ در سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_back_logo',
				'label'        => esc_html__('رنگ پس زمینه لوگو', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه لوگو در سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color__icon__header',
				'label'        => esc_html__('رنگ آیکون ها', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ  آیکون ها', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_menu_mobile',
				'label'        => esc_html__('رنگ آیکون منو موبایل', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ آیکون منو موبایل', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'head_four',
				'label'        => esc_html__('سربرگ 4', 'liosa'),
				'desc'         => esc_html__('سربرگ 4', 'liosa'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show__menu_bar_four',
				'label'        => esc_html__('فعال کردن منوبار', 'liosa'),
				'desc'         => esc_html__('فعال /غیر فعال کردن منو بار در سربرگ چهار', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_bac_menubar_four',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_bac_main_menu_four',
				'label'        => esc_html__('رنگ پس زمینه منو', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو اصلی سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_header_four',
				'label'        => esc_html__('رنگ متن سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن سربرگ ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_menubar_four',
				'label'        => esc_html__('رنگ پس زمینه منو بار', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه منو بار در سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_menubar_four',
				'label'        => esc_html__('رنگ متن منو بار', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن منو بار در سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_four',
				'label'        => esc_html__('رنگ آیکون و منو ها', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ آیکون ها و منو در سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_baner_four',
				'label'        => esc_html__('بنر سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب بنر سربرگ چهار', 'liosa'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_link_baner_four',
				'label'        => esc_html__('لینک بنر سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک بنر سربرگ چهار', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_baner_code_html_four',
				'label'        => esc_html__('بنر سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب بنر سربرگ چهار بصورت متنی و HTML', 'liosa'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'head_five',
				'label'        => esc_html__('سربرگ 5', 'liosa'),
				'desc'         => esc_html__('سربرگ 5', 'liosa'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_bac_menubar_five',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_header_five',
				'label'        => esc_html__('رنگ متن سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن سربرگ ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_five',
				'label'        => esc_html__('رنگ آیکون ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ آیکون ها در سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_tab_6',
				'label'        => esc_html__('سربرگ 6', 'liosa'),
				'desc'         => esc_html__('سربرگ شش', 'liosa'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_shop_header_6',
				'label'        => esc_html__('رنگ پس زمینه سربرگ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_menu_background_6',
				'label'        => esc_html__('منو', 'liosa'),
				'desc'         => esc_html__('انتخاب پس زمینه منو', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_menu_6',
				'label'        => esc_html__('رنگ متن ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_menu_6',
				'label'        => esc_html__('رنگ متن منو ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن منو سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_6',
				'label'        => esc_html__('رنگ متن و آیکون', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن و آیکون سربرگ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'border_color_search_6',
				'label'        => esc_html__('حاشیه جستجو', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ حاشیه جستجو', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_border_profile_6',
				'label'        => esc_html__('پروفایل', 'liosa'),
				'desc'         => esc_html__('انتخاب حاشیه پروفایل کاربران ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_profile_6',
				'label'        => esc_html__('پروفایل', 'liosa'),
				'desc'         => esc_html__('انتخاب پس زمینه پروفایل کاربران ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'fullwidth_shop_color_6',
				'label'        => esc_html__('سبد خرید', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه سبد خرید', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'fullwidth_shop_color_text_6',
				'label'        => esc_html__('سبد خرید', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن سبد خرید', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'fullwidth_shop_badge_6',
				'label'        => esc_html__('تعداد سبد خرید', 'liosa'),
				'desc'         => esc_html__('انتخاب پس زمینه تعداد کالا در سبد خرید', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'header_radius_6',
				'label'        => esc_html__('گردی', 'liosa'),
				'desc'         => esc_html__('تنظیم گردی سربرگ ', 'liosa'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'header',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_article_popular',
				'label'        => esc_html__('نمایش مطالب پربازدید', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن مطالب پربازدید در صفحه نوشته ها', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'select_related_posts',
				'label'        => ' سبک مطالب مرتبط',
				'desc'         => 'انتخاب سبک نمایش مطالب مرتبط در صفحه داخلی پیش فرض',
				'std'          => '',
				'type'         => 'select',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
				'choices'      => array(
					array(
						'value' => 'posts_list',
						'label' => 'لیست',
						'src'   => '',
					),
					array(
						'value' => 'posts_box',
						'label' => 'باکس',
						'src'   => '',
					),
				),
			),
			array(
				'id'           => 'news_audio_down',
				'label'        => esc_html__('نمایش اطلاعات مفید', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن اطلاعات مفید بر روی تصویر شاخص صفحه نوشته (بازدید ، دانلود ، فایل صوتی ، pdf)', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'content_post_img',
				'label'        => esc_html__(' عرض تصاویر', 'liosa'),
				'desc'         => esc_html__('تمام عرض / استاندارد سایز تصاویر در پست نوشته ها', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'news_audio_down_download',
				'label'        => esc_html__('نمایش اطلاعات مفید', 'liosa'),
				'desc'         => esc_html__(' فعال و غیر فعال کردن اطلاعات مفید نمایش در صفحه داخلی دانلود (بازدید ، دانلود ، فایل صوتی ، pdf) ', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),	
			array(
				'id'           => 'content_post_color',
				'label'        => esc_html__('رنگ نوشته ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پست نوشته ها', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'content_images_color_back',
				'label'        => esc_html__('رنگ پس زمینه تصویر ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه توضیحات تصویر ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'content_images_color',
				'label'        => esc_html__('رنگ متن تصویر ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن توضیحات تصویر ', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'content_post_number_related',
				'label'        => esc_html__('مطالب مرتبط ', 'liosa'),
				'desc'         => esc_html__('انتخاب تعداد مطالب مرتبط در صفحه نوشته', 'liosa'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'avatar_name',
				'label'        => esc_html__('نام نویسنده', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن نام نویسنده', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_viwe',
				'label'        => esc_html__('تعداد بازدید', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن تعداد بازدید', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_time',
				'label'        => esc_html__('تاریخ نوشته', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن تاریخ نوشته', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_share',
				'label'        => esc_html__('اشتراک گذاری', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن اشتراک گذاری', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'comments_number',
				'label'        => esc_html__('تعداد کامنت', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن تعداد کامنت', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'd_category',
				'label'        => esc_html__('دسته بندی ها', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دسته بندی ها', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'comment_rules',
				'label'        => esc_html__('قوانین نظرات', 'liosa'),
				'desc'         => esc_html__('متن قوانین ارسال دیدگاه ، قوانین بصورت لیست نوشته شود و از ul > li استفاده کنید.', 'liosa'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'post_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_read_more',
				'label'        => esc_html__('نمایش بیشتر بخوانید ', 'liosa'),
				'desc'         => esc_html__('فعال / غیر فعال کردن نمایش بیشتر در صفحه نوشته ', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_read_more_archive',
				'label'        => esc_html__('نمایش بیشتر بخوانید ', 'liosa'),
				'desc'         => esc_html__('فعال / غیر فعال کردن نمایش بیشتر در صفحه آرشیو', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_read_more',
				'label'        => esc_html__('عنوان بیشتر بخوانید ', 'liosa'),
				'desc'         => esc_html__('انتخاب عنوان بیشتر بخوانید در صفحه نوشته ها', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'item_read_more',
				'label'        => esc_html__('تعداد مطالب ', 'liosa'),
				'desc'         => esc_html__('انتخاب تعداد مطالب ،بیشتر بخوانید در صفحه نوشته ها', 'liosa'),
				'std'          => '',
				'type'         => 'numeric-slider',
				'section'      => 'read_more',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'          => 'category_select_id_1',
				'label'       => __('انتخاب دسته بندی ستون یک', 'liosa'),
				'desc'        => __('انتخاب دسته بندی بیشتر بخوانید در صفحه نوشته', 'liosa'),
				'std'         => '',
				'type'        => 'category-select',
				'section'     => 'read_more',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step' => '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'category_select_id_2',
				'label'       => __('انتخاب دسته بندی ستون دو', 'liosa'),
				'desc'        => __('انتخاب دسته بندی بیشتر بخوانید در صفحه نوشته', 'liosa'),
				'std'         => '',
				'type'        => 'category-select',
				'section'     => 'read_more',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step' => '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'category_select_id_3',
				'label'       => __('انتخاب دسته بندی ستون سه', 'liosa'),
				'desc'        => __('انتخاب دسته بندی بیشتر بخوانید در صفحه نوشته', 'liosa'),
				'std'         => '',
				'type'        => 'category-select',
				'section'     => 'read_more',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step' => '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'          => 'category_select_id_4',
				'label'       => __('انتخاب دسته بندی ستون چهار', 'liosa'),
				'desc'        => __('انتخاب دسته بندی بیشتر بخوانید در صفحه نوشته', 'liosa'),
				'std'         => '',
				'type'        => 'category-select',
				'section'     => 'read_more',
				'rows'        => '',
				'post_type'   => '',
				'taxonomy'    => '',
				'min_max_step' => '',
				'class'       => '',
				'condition'   => '',
				'operator'    => 'and'
			),
			array(
				'id'           => 'general_footer',
				'label'        => esc_html__('عمومی', 'liosa'),
				'desc'         => esc_html__('عمومی', 'liosa'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'background_footer_blog',
				'label'        => esc_html__('Blog Footer Background', 'liosa'),
				'desc'         => esc_html__('Choose a footer background on the blog', 'liosa'),
				'std'          => '',
				'type'         => 'background',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_footer_text_menu',
				'label'        => esc_html__('Footer menu color text', 'liosa'),
				'desc'         => esc_html__('Color the menu text in the blog footer', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'copyright_text',
				'label'        => esc_html__('Copyright text', 'liosa'),
				'desc'         => esc_html__('Copyright text in the blog footer', 'liosa'),
				'std'          => '',
				'type'         => 'textarea-simple',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'copyright_text_color',
				'label'        => esc_html__('Copyright text color', 'liosa'),
				'desc'         => esc_html__('The color of the copyrighted text in the blog footer', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'title_text_color',
				'label'        => esc_html__('color title', 'liosa'),
				'desc'         => esc_html__('The color of the title text in the blog footer', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'icon_social_text_color',
				'label'        => esc_html__('color icon', 'liosa'),
				'desc'         => esc_html__('The color of the icon social in the blog footer', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'footer_social',
				'label'        => esc_html__('شبکه اجتماعی', 'liosa'),
				'desc'         => esc_html__('شبکه اجتماعی', 'liosa'),
				'std'          => '',
				'type'         => 'tab',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_social',
				'label'        => esc_html__('نمایش شبکه اجتماعی', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن شبکه اجتماعی ', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'social_links',
				'label'        => esc_html__('social network', 'liosa'),
				'desc'         => '',
				'std'          => '',
				'type'         => 'social-links',
				'section'      => 'footer_blog',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_search_advanced',
				'label'        => esc_html__('نمایش جستجوی پیشرفته', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن جستجوی پیشرفته ', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_img_1',
				'label'        => esc_html__('آپلود تصویر', 'liosa'),
				'desc'         => esc_html__('انتخاب تصویر نمایش در بخش جستجوی پاپ اپ', 'liosa'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_link_1',
				'label'        => esc_html__('لینک تصویر', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک نمایش در بخش جستجوی پاپ اپ', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_img_2',
				'label'        => esc_html__('آپلود تصویر', 'liosa'),
				'desc'         => esc_html__('انتخاب تصویر نمایش در بخش جستجوی پاپ اپ', 'liosa'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_link_2',
				'label'        => esc_html__('لینک تصویر', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک نمایش در بخش جستجوی پاپ اپ', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_img_3',
				'label'        => esc_html__('آپلود تصویر', 'liosa'),
				'desc'         => esc_html__('انتخاب تصویر نمایش در بخش جستجوی پاپ اپ', 'liosa'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_link_3',
				'label'        => esc_html__('لینک تصویر', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک نمایش در بخش جستجوی پاپ اپ', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_img_4',
				'label'        => esc_html__('آپلود تصویر', 'liosa'),
				'desc'         => esc_html__('انتخاب تصویر نمایش در بخش جستجوی پاپ اپ', 'liosa'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'search_advanced_link_4',
				'label'        => esc_html__('لینک تصویر', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک نمایش در بخش جستجوی پاپ اپ', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'search',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_backgrund_add_cart',
				'label'        => esc_html__('رنگ پس زمینه دکمه سبد خرید', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه دکمه افزودن به سبد خرید در صفحه محصول', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'product_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_text_add_cart',
				'label'        => esc_html__('رنگ متن دکمه سبد خرید', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ متن دکمه افزودن به سبد خرید در صفحه محصول', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'product_single',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_call_back_to_top',
				'label'        => esc_html__('لینک تماس', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک تماس با ما یا لینک تلگرام ، واتساپ و...', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_call_back_to_top',
				'label'        => esc_html__('متن نگهدارنده تماس', 'liosa'),
				'desc'         => esc_html__('انتخاب شماره تماس  یا ایدی تلگرام ، واتساپ و...', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_profile_back',
				'label'        => esc_html__('نمایش پروفایل', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه پروفایل کاربری', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_share_back',
				'label'        => esc_html__('نمایش اشتراک گذاری', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه اشتراک گذاری', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_call_back',
				'label'        => esc_html__('نمایش تماس باما', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه تماس با ما', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'display_back_to_top',
				'label'        => esc_html__('نمایش بازگشت به بالا', 'liosa'),
				'desc'         => esc_html__('فعال و غیر فعال کردن دکمه بازگشت به بالا', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_background_back_to_top',
				'label'        => esc_html__('رنگ پس زمینه', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه دکمه ها', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_icon_back_to_top',
				'label'        => esc_html__('رنگ آیکون ها', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ آیکون ها', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_hover_back_to_top',
				'label'        => esc_html__('رنگ پس زمینه هاور ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ پس زمینه هاور شدن دکمه ها', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'color_hover_text_back_to_top',
				'label'        => esc_html__('رنگ  متن هاور ', 'liosa'),
				'desc'         => esc_html__('انتخاب رنگ  متن هنگام هاور شدن دکمه ها', 'liosa'),
				'std'          => '',
				'type'         => 'colorpicker-opacity',
				'section'      => 'back_to_top',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_profile_user',
				'label'        => esc_html__('page profile ', 'liosa'),
				'desc'         => esc_html__('select page profile users', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'profile_user',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'text_profile_user',
				'label'        => esc_html__('text contact ', 'liosa'),
				'desc'         => esc_html__('text contact profile users', 'liosa'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'profile_user',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'show_social_network',
				'label'        => esc_html__('نمایش شبکه اجتماعی ', 'liosa'),
				'desc'         => esc_html__('فعال / غیر فعال کردن نمایش شبکه اجتماعی در بالای فوتر', 'liosa'),
				'std'          => '',
				'type'         => 'on-off',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_instagram',
				'label'        => esc_html__('لینک اینستاگرام', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک صفحه اینستاگرام، نمایش در بالای فوتر', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_telegram',
				'label'        => esc_html__('لینک تلگرام', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک صفحه تلگرام نمایش در بالای فوتر', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_aparat',
				'label'        => esc_html__('لینک آپارات', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک صفحه آپارات نمایش در بالای فوتر', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_twitter',
				'label'        => esc_html__('لینک توییتر', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک صفحه توییتر نمایش در بالای فوتر', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'link_youtube',
				'label'        => esc_html__('لینک یوتیوب', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک صفحه یوتیوب نمایش در بالای فوتر', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'social_network',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_area_title',
				'label'        => esc_html__('عنوان تبلیغات', 'liosa'),
				'desc'         => esc_html__('درج عنوان تبلیغات نمایش در صفحات داخلی', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_area',
				'label'        => esc_html__('متن یا کد تبلیغات', 'liosa'),
				'desc'         => esc_html__('درج متن تبلیغات یا درج کد پلتفرم های تبلیغاتی همانند یکتانت', 'liosa'),
				'std'          => '',
				'type'         => 'textarea',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_post_top',
				'label'        => esc_html__('بنر تبلیغات نوشته', 'liosa'),
				'desc'         => esc_html__('انتخاب بنر تبلیغاتی در بالای صفحه نوشته', 'liosa'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_post_top_link',
				'label'        => esc_html__('لینک تبلیغاتی نوشته', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک بنر  تبلیغاتی در بالای صفحه نوشته', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_post_bot',
				'label'        => esc_html__('بنر تبلیغات نوشته', 'liosa'),
				'desc'         => esc_html__('انتخاب بنر تبلیغاتی در پایین صفحه نوشته', 'liosa'),
				'std'          => '',
				'type'         => 'upload',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'advertising_post_bot_link',
				'label'        => esc_html__('لینک تبلیغاتی نوشته', 'liosa'),
				'desc'         => esc_html__('انتخاب لینک بنر  تبلیغاتی در پایین صفحه نوشته', 'liosa'),
				'std'          => '',
				'type'         => 'text',
				'section'      => 'advertising',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
			array(
				'id'           => 'add_css_advan',
				'label'        => esc_html__('custom css', 'liosa'),
				'desc'         => '',
				'std'          => '',
				'type'         => 'css',
				'section'      => 'advanced',
				'rows'         => '',
				'post_type'    => '',
				'taxonomy'     => '',
				'min_max_step' => '',
				'class'        => '',
				'condition'    => '',
				'operator'     => 'and',
			),
		)
	);

	// Allow settings to be filtered before saving.
	$custom_settings = apply_filters(ot_settings_id() . '_args', $custom_settings);

	// Settings are not the same update the DB.
	if ($saved_settings !== $custom_settings) {
		update_option(ot_settings_id(), $custom_settings);
	}

	// Lets OptionTree know the UI Builder is being overridden.
	global $ot_has_custom_theme_options;
	$ot_has_custom_theme_options = true;
	$select_classic = ot_get_option('select_classic');
	if ($select_classic == 'classic') {
	add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
	add_filter( 'use_widgets_block_editor', '__return_false' );
	}
	/* ------------------------------------------------  top and down sidbar mobile ----------------------------*/
}
