<?php
add_action('admin_menu', 'liosa_add_metabox');

function liosa_add_metabox()
{

    add_meta_box(
        'liosa_metabox', // metabox ID
        __('header', 'liosa'),
        'liosa_metabox_callback', // callback function
        ['post', 'page', 'product'], // post type or post types in array
        'side', // position (normal, side, advanced)
        'default' // priority (default, low, high, core)
    );
}


function liosa_metabox_callback($post)
{

    $seo_title = get_post_meta($post->ID, 'seo_title', true);
    $seo_robots = get_post_meta($post->ID, 'seo_robots', true);
    $tag_types = get_post_meta($post->ID, 'tag_types', true);
    // nonce, actually I think it is not necessary here
    wp_nonce_field('somerandomstr', '_liosanonce'); ?>
    <table class="form-table">
        <tbody>
            <!--
            <tr>
                <th><label for="seo_title">SEO title</label></th>
                <td><input type="text" id="seo_title" name="seo_title" value="<?php esc_attr($seo_title); ?>" class="regular-text"></td>
            </tr>
-->
            <tr>
                <th><label for="seo_tobots"><?php _e('select header', 'liosa'); ?></label></th>
                <td>
                    <select id="seo_robots" name="seo_robots">
                        <option value="">Select...</option>
                        <option value="header_1" <?php selected(' header_1', $seo_robots, false); ?>><?php _e('header 1', 'liosa'); ?></option>
                        <option value="header_2" <?php selected('header_2', $seo_robots, false); ?>><?php _e('header 2', 'liosa'); ?></option>
                        <option value="header_3" <?php selected('header_3', $seo_robots, false); ?>><?php _e('header 3', 'liosa'); ?></option>
                        <option value="header_4" <?php selected('header_4', $seo_robots, false); ?>><?php _e('header 4', 'liosa'); ?></option>
                        <option value="header_5" <?php selected('header_5', $seo_robots, false); ?>><?php _e('header 5', 'liosa'); ?></option>
                        <option value="header_6" <?php selected('header_6', $seo_robots, false); ?>><?php _e('header 6', 'liosa'); ?></option>
                    </select>
                </td>
            </tr>
            <tr>
                <th><label for="tag_type"><?php _e('type post', 'liosa'); ?></label></th>
                <td>
                    <select id="tag_types" name="tag_types">
                        <option value="">Select...</option>
                        <option value="podcatch" <?php selected('podcatch', $tag_types, false); ?>><?php _e('podcatch', 'liosa'); ?></option>
                        <option value="video" <?php selected('video', $tag_types, false); ?>><?php _e('video', 'liosa'); ?></option>
                        <option value="images" <?php selected('images', $tag_types, false); ?>><?php _e('images', 'liosa'); ?></option>
                        <option value="survey" <?php selected('survey', $tag_types, false); ?>><?php _e('survey', 'liosa'); ?></option>
                    </select>
                </td>
            </tr>
        </tbody>
    </table>
<?php
}
add_action('save_post', 'liosa_save_meta', 10, 2);
add_action('save_post', 'liosa_save_metap', 10, 2);
add_action('save_post', 'liosa_save_metapr', 10, 2);
function liosa_save_meta($post_id, $post)
{

    // nonce check
    if (!isset($_POST['_liosanonce']) || !wp_verify_nonce($_POST['_liosanonce'], 'somerandomstr')) {
        return $post_id;
    }

    // check current use permissions
    $post_type = get_post_type_object($post->post_type);

    if (!current_user_can($post_type->cap->edit_post, $post_id)) {
        return $post_id;
    }

    // Do not save the data if autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }

    // define your own post type here
    $slug = "page";
    if ($slug != $post->post_type) {
        return $post_id;
    }
    if (isset($_POST['seo_title'])) {
        update_post_meta($post_id, 'seo_title', sanitize_text_field($_POST['seo_title']));
    } else {
        delete_post_meta($post_id, 'seo_title');
    }
    if (isset($_POST['seo_robots'])) {
        update_post_meta($post_id, 'seo_robots', sanitize_text_field($_POST['seo_robots']));
    } else {
        delete_post_meta($post_id, 'seo_robots');
    }
    if (isset($_POST['tag_types'])) {
        update_post_meta($post_id, 'tag_types', sanitize_text_field($_POST['tag_types']));
    } else {
        delete_post_meta($post_id, 'tag_types');
    }
    return $post_id;
}
function liosa_save_metap($post_id, $post)
{

    // nonce check
    if (!isset($_POST['_liosanonce']) || !wp_verify_nonce($_POST['_liosanonce'], 'somerandomstr')) {
        return $post_id;
    }

    // check current use permissions
    $post_type = get_post_type_object($post->post_type);

    if (!current_user_can($post_type->cap->edit_post, $post_id)) {
        return $post_id;
    }

    // Do not save the data if autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }

    // define your own post type here
    $slug = "post";
    if ($slug != $post->post_type) {
        return $post_id;
    }
    if (isset($_POST['seo_title'])) {
        update_post_meta($post_id, 'seo_title', sanitize_text_field($_POST['seo_title']));
    } else {
        delete_post_meta($post_id, 'seo_title');
    }
    if (isset($_POST['seo_robots'])) {
        update_post_meta($post_id, 'seo_robots', sanitize_text_field($_POST['seo_robots']));
    } else {
        delete_post_meta($post_id, 'seo_robots');
    }
    if (isset($_POST['tag_types'])) {
        update_post_meta($post_id, 'tag_types', sanitize_text_field($_POST['tag_types']));
    } else {
        delete_post_meta($post_id, 'tag_types');
    }
    return $post_id;
}
function liosa_save_metapr($post_id, $post)
{

    // nonce check
    if (!isset($_POST['_liosanonce']) || !wp_verify_nonce($_POST['_liosanonce'], 'somerandomstr')) {
        return $post_id;
    }

    // check current use permissions
    $post_type = get_post_type_object($post->post_type);

    if (!current_user_can($post_type->cap->edit_post, $post_id)) {
        return $post_id;
    }

    // Do not save the data if autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }

    // define your own post type here
    $slug = "product";
    if ($slug != $post->post_type) {
        return $post_id;
    }
    if (isset($_POST['seo_title'])) {
        update_post_meta($post_id, 'seo_title', sanitize_text_field($_POST['seo_title']));
    } else {
        delete_post_meta($post_id, 'seo_title');
    }
    if (isset($_POST['seo_robots'])) {
        update_post_meta($post_id, 'seo_robots', sanitize_text_field($_POST['seo_robots']));
    } else {
        delete_post_meta($post_id, 'seo_robots');
    }
    if (isset($_POST['tag_types'])) {
        update_post_meta($post_id, 'tag_types', sanitize_text_field($_POST['tag_types']));
    } else {
        delete_post_meta($post_id, 'tag_types');
    }
    return $post_id;
}
