<?php

/**
 * Image box
 *
 */

use \Elementor\Group_Control_Image_Size;

if (!defined('ABSPATH')) {
	exit;
}

class Background_Image_Written extends \Elementor\Widget_Base
{

	public function get_name()
	{
		return 'image-boxx';
	}

	public function get_title()
	{
		return __('image box', 'liosa');
	}

	public function get_icon()
	{
		return 'eicon-image-hotspot';
	}

	public function get_categories()
	{
		return ['elementor-widget-be-shop'];
	}

	    protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'liosa'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_title',
			[
				'label' => __('Title', 'liosa'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('List Title', 'liosa'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'image',
			[
				'label' => __('Choose Image slider', 'liosa'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'default' => 'full',
				'separator' => 'none',
			]
		);
		$repeater->add_control(
			'website_link',
			[
				'label' => __('Link', 'liosa'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'liosa'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __('Repeater List', 'liosa'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __('Title #1', 'liosa'),
						'list_content' => __('Item content. Click the edit button to change this text.', 'liosa'),
					],
					[
						'list_title' => __('Title #2', 'liosa'),
						'list_content' => __('Item content. Click the edit button to change this text.', 'liosa'),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
?>
		<div class="container">
			<div class="c-adplacement mb-3">
				<?php
				if ($settings['list']) {
					foreach ($settings['list'] as $item) { ?>
						<a class="c-adplacement__item--b c-adplacement__item" href="<?php echo $item['website_link']['url']; ?>" class="wo-main-slider__slide swiper-slide">
							<div class="c-adplacement__sponsored_box">
								<?php echo Group_Control_Image_Size::get_attachment_image_html($item, 'thumbnail', 'image'); ?>
							</div>
						</a>
				<?php }
				} ?>
			</div>
		</div>
<?php
	}
}
