<div class="container">
    <section class="custom_widget_user">
        <div class="row">
            <div class="col-12">
                <?php if ('yes' === $settings['show_more']): ?>
                <div class="breaking_news__title">
                    <div class="news__title_text">
                        <?php echo $settings['title']; ?></div>
                    <span class="news__title_left"></span>
                    <?php if($settings['title_more_two']): ?>
                    <a href="<?php echo $settings['website_link']; ?>"title="<?php echo $settings['title_more_two']; ?>"><?php echo $settings['title_more_two']; ?></a>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
            <?php
            while ($query->have_posts()) :
            $query->the_post(); ?>
            <div class="col-12 col-md-6 col-lg-4">
                <div class="breaking_news__item">
                    <a href="<?php the_permalink(); ?>" class="breaking_news__item_link">
                        <div class="breaking_news__header">
                            <div class="breaking_news__image-box">
                                <?php
                        if (has_post_thumbnail()) {
                            the_post_thumbnail('medium', array('alt' => '' . get_the_title(), 'title' => '' . get_the_title() . ''));
                        } else { ?>
                                <img src="<?php bloginfo('template_url'); ?>/assets/images/thumb.gif" width="60"
                                    height="60" alt="<?php _e('Image not found', 'liosa'); ?>"
                                    title="<?php _e('Image not found', 'liosa'); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="breaking_news_content">
                            <div class="breaking_news_info">
                                <div class="breaking_news_info_time">
                                    <time><?php do_action('type_article'); echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?></time>
                                </div>
                                <?php if (info_content_get_meta( 'info_content_audio_link' )): ?>
                                <div class="breaking_news_audio">
                                    <audio controls src="<?php echo info_content_get_meta( 'info_content_audio_link' ); ?>">
                                        Your browser does not support the
                                        <code>audio</code> element.
                                    </audio>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="cus_breaking_news__title">
                                <?php the_title(); ?>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
            <?php endwhile;
                    // Pagination.
                    if (!empty($settings['grid_pagination'])) {
                    ?>
            <div class="pagination">
                <?php
                            $big = 999999999;
                            $totalpages = $query->max_num_pages;
                            $current = max(1, $paged);
                            $paginate_args = array(
                                'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
                                'format'    => '?paged=%#%',
                                'current'   => $current,
                                'total'     => $totalpages,
                                'show_all'  => false,
                                'end_size'  => 1,
                                'mid_size'  => 1,
                                'prev_next' => true,
                                'prev_text'          => __('<i class="fa fa-chevron-right" aria-hidden="true"></i>', 'twentyfifteen'),
                                'next_text'          => __('<i class="fa fa-chevron-left" aria-hidden="true"></i>', 'twentyfifteen'),
                                'screen_reader_text' => __('A')
                            );

                            $pagination = paginate_links($paginate_args);
                            ?>
                <nav class="pagenumbers">
                    <?php echo $pagination; ?>
                </nav>
            </div>
            <?php
        }
            wp_reset_postdata();
        ?>
        </div>
    </section>
</div>