<div class="container main-content sidbar-2">
  <div class="module-title">
    <div class="row">
      <div class="col-12">
        <h2 class="color_custom"><span><?php echo $settings['title']; ?></span></h2>
        <span class="module-title__sep sl_th"></span>
      </div>
    </div>
  </div>
  <div class="row">
    <?php do_action('top_post_widget'); ?>
    <div class="col-12 col-lg-9 pal_0 content content-fix">
      <div class="main hid_pad home-col">
        <article class="root">
          <?php
          while ($query->have_posts()) :
            $query->the_post();
          ?>
            <div class="content_item">
              <div class="content_item_time">
                <div class="content_item__time">
                  <div class="content_item__time">
                    <?php $archive_year  = get_the_time('Y'); ?>
                    <?php $archive_month = get_the_time('m'); ?>
                    <a href="<?php echo get_month_link($archive_year, $archive_month); ?>">
                      <span class="content_item__icon"><i class="fal fa-clock"></i></span>
                      <span class="content_item__timeago">
                        <time><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?></time>
                      </span>
                    </a>
                  </div>
                </div>
              </div>
              <div class="content_item__cart">
                <article class="content_item__cart__link">
                  <div class="content_item__cart__media">
                    <a href="<?php the_permalink(); ?>">
                      <figure class="content_item__cart__media__image">
                        <?php
                        if (has_post_thumbnail()) {
                          the_post_thumbnail(array(300, 300), array('alt' => '' . get_the_title(), 'title' => '' . get_the_title() . ''));
                        } else { ?>
                          <img src="<?php bloginfo('template_url'); ?>/assets/images/thumb.gif" width="60" height="60" alt="<?php _e('Image not found', 'liosa'); ?>" title="<?php _e('Image not found', 'liosa'); ?>">
                        <?php } ?>
                      </figure>
                    </a>
                  </div>
                  <div class="content_item__cart__detail">
                    <div class="content_item__cart__detail__container">
                      <div class="content_item__cart__detail-top">
                        <h5 class="content_item__cart__detail__category">
                          <?php do_action('type_article'); the_category(); ?>
                        </h5>
                        <span class="content_item__cart__detail__time">
                          <?php $archive_year  = get_the_time('Y'); ?>
                          <?php $archive_month = get_the_time('m'); ?>
                          <a href="<?php echo get_month_link($archive_year, $archive_month); ?>">
                            <time><?php do_action('type_article'); echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?></time>
                          </a>
                        </span>
                      </div>
                      <h3 class="content_item__cart__detail__title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                      </h3>
                      <div class="content_item__cart__detail__excerpt">
                        <div class="desc">
                          <?php echo '<p class="text text_1">' . get_the_excerpt() . '</p>'; ?>
                        </div>
                      </div>
                    </div>
                  </div>
                </article>
              </div>
            </div>
          <?php endwhile;
          if (!empty($settings['grid_pagination'])) {
          ?>
            <div class="pagination root" style="width: 100%;">
              <?php
              $big = 999999999;
              $totalpages = $query->max_num_pages;
              $current = max(1, $paged);
              $paginate_args = array(
                'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
                'format'    => '?paged=%#%',
                'current'   => $current,
                'total'     => $totalpages,
                'show_all'  => false,
                'end_size'  => 1,
                'mid_size'  => 3,
                'prev_next' => true,
                'prev_text'          => __('<i class="fa fa-chevron-right" aria-hidden="true"></i>', 'liosa'),
                'next_text'          => __('<i class="fa fa-chevron-left" aria-hidden="true"></i>', 'liosa'),
                'screen_reader_text' => __('A', 'liosa')
              );
              $pagination = paginate_links($paginate_args);
              ?>
              <nav class="pagenumbers">
                <?php echo $pagination; ?>
              </nav>
            </div>
          <?php
          }
          ?>
        </article>
      </div>
    </div>
    <?php 
      do_action('down_post_widget');
      get_sidebar('page'); 
    ?>
  </div>