<?php

/**
 * Elementor Header Box Widget.
 *
 */

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Scheme_Typography;
use Elementor\Core\Schemes\Color;
use Elementor\Group_Control_Image_Size;


class Dimag_Sidbar extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'dimag-sidbar';
  }

  public function get_title()
  {
    return __(' sidbar', 'liosa');
  }

  public function get_icon()
  {
    return 'eicon-sidebar';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }


  private function grid_get_all_post_type_categories($post_type)
  {
    $options = array();

    if ($post_type == 'post') {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }

      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
  {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Content', 'liosa'),
      ]
    );
    $this->add_control(
      'grid_style',
      [
        'label' => __('Grid Style', 'liosa'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '1',
        'options' => [
          '1' => esc_html__('Layout 1', 'liosa'),
          '2' => esc_html__('Layout 2', 'liosa'),
          '3' => esc_html__('Layout 3', 'liosa'),
          '4' => esc_html__('Layout 4', 'liosa'),
        ],
      ]
    );
    $this->add_control(
      'title',
      [
        'label' => __('Title', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title_more_two',
      [
        'label' => __(' مشاهده بیشتر', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'condition' => [
          'grid_style' => '4',
        ]
      ]
    );
    $this->add_control(
      'title_more',
      [
        'label' => __('توضیحات', 'liosa'),
        'type' => \Elementor\Controls_Manager::WYSIWYG,
        'default' => __('Default description', 'liosa'),
        'placeholder' => __('Type your description here', 'liosa'),
        'condition' => [
          'grid_style' => '3',
        ]
      ]
    );
    $this->add_control(
      'grid_post_type',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-tag"></i> ' . __('Post Type', 'liosa'),
        'default' => 'post',
        'options' => $this->grid_get_all_post_types(),
      ]
    );
    $this->add_control(
      'grid_items',
      [
        'type'        => \Elementor\Controls_Manager::NUMBER,
        'label'       => '<i class="fa fa-th-large"></i> ' . __('Items', 'liosa'),
        'placeholder' => __('How many items?', 'liosa'),
        'default'     => 14,
      ]
    );

    // Post categories.
    $this->add_control(
      'grid_post_categories',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-folder"></i> ' . __('Category', 'liosa'),
        'options' => $this->grid_get_all_post_type_categories('post'),
        'condition' => [
          'grid_post_type' => 'post',
        ],
      ]
    );
    $this->add_control(
      'show_more',
      [
        'label' => __('Show more', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'website_link',
      [
        'label' => __('Link More', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'grid_pagination',
      [
        'label' => '<i class="fa fa-arrow-circle-right"></i> ' . __('Pagination', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => '',
      ]
    );
    // Order by.
    $this->add_control(
      'grid_order_by',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-sort"></i> ' . __('Order by', 'liosa'),
        'default' => 'date',
        'options' => [
          'date'          => __('Date', 'liosa'),
          'title'         => __('Title', 'liosa'),
          'modified'      => __('Modified date', 'liosa'),
          'comment_count' => __('Comment count', 'liosa'),
          'rand'          => __('Random', 'liosa'),
        ],
      ]
    );

    // Price.
    $this->add_control(
      'grid_content_price',
      [
        'label' => '<i class="fa fa-usd"></i> ' . __('Price', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes',
        'condition' => [
          'section_grid.grid_post_type' => 'product',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'section_style',
      [
        'label' => __('header ', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color',
      [
        'label' => __('background color', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#eee',
        
        'selectors' => [
          '{{WRAPPER}} .sidbar-1 .module-title h2,.sidbar-2 .module-title h2,.breaking_news__title a' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .sidbar-1 .module-title__sep,.sidbar-2 .module-title__sep' => 'border-color: {{VALUE}}',
        ],
        'condition' => [
          'grid_style!' => '3',
        ]
      ]
    );
    $this->add_control(
      'title_color_show_more',
      [
        'label' => __('Title', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#6b7074',
        
        'selectors' => [
          '{{WRAPPER}} .breaking_news__title .news__title_text,.sidbar-1 .module-title h2.color_custom,.sidbar-2 .module-title h2.color_custom,h1.cb-module-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_mor',
      [
        'label' => __('Title More', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
        
        'selectors' => [
          '{{WRAPPER}} .breaking_news__title a' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'grid_style' => '4',
        ]
      ]
    );
    $this->add_control(
      'title_color_des',
      [
        'label' => __('description', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#212529',
        
        'selectors' => [
          '{{WRAPPER}} .widt-sidbar_3 .taxonomy-description' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'grid_style' => '3',
        ]
      ]
    );
    $this->add_control(
      'border_radius',
      [
        'label' => __( 'border radius', 'liosa' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 5,
        ],
        'selectors' => [
          '{{WRAPPER}} .sidbar-1 .module-title h2.color_custom,.sidbar-2 .module-title h2.color_custom,.breaking_news__title a' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
        ],
        'condition' => [
          'grid_style!' => '3',
        ]
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_1',
      [
        'label' => __('Page counter', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'counter_active',
      [
        'label' => __('background color active', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fb3449',
        
        'selectors' => [
          '{{WRAPPER}} .pagenumbers span.current, .pagenumbers span:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'counter_text_active',
      [
        'label' => __('text active', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
        
        'selectors' => [
          '{{WRAPPER}} .pagenumbers span.current, .pagenumbers span:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'counter',
      [
        'label' => __('background color', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
        
        'selectors' => [
          '{{WRAPPER}} .pagenumbers a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'counter_text',
      [
        'label' => __('text', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#616161',
        
        'selectors' => [
          '{{WRAPPER}} .pagenumbers a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'border_radius_numbe',
      [
        'label' => __( 'border radius', 'liosa' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 5,
        ],
        'selectors' => [
          '{{WRAPPER}} .pagenumbers a,.pagenumbers span.current' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'section_style_box',
      [
        'label' => __( 'box', 'liosa' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name' => 'box_shadow',
        'label' => esc_html__( 'Box Shadow', 'liosa' ),
        'selector' => '{{WRAPPER}} .widt-sidbar_3 .solid-home a img,.content_item__cart__media__image,.content_item__cart__link,.topics-gallery__item',
        'condition' => [
          'grid_style!' => '4',
        ]
      ]
    );
    $this->add_control(
      'border_radius_article_5',
      [
        'label' => __( 'border radius', 'liosa' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 5,
        ],
        'selectors' => [
          '{{WRAPPER}} .widt-sidbar_3 .solid-home a img,.content_item__cart__media__image,.content_item__cart__link,.topics-gallery__item' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
          '{{WRAPPER}} .breaking_news__item .breaking_news__header .breaking_news__image-box img' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
        ],
      ]
    );
     $this->end_controls_section();
  }


  protected function render()
  {
    $settings = $this->get_settings();
    $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
    $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';

    $args = array();
    $grid_style = $settings['grid_style'];
    $args['post_status'] = 'publish';
    $args['ignore_sticky_posts'] = 1;
    if (!empty($settings['grid_post_type']) && post_type_exists($settings['grid_post_type'])) {
      $args['post_type'] = $settings['grid_post_type'];
    }
    if (!empty($settings['grid_post_categories']) && $settings['grid_post_type'] == 'post') {
      $args['category_name'] = $settings['grid_post_categories'];
    }
    if (!empty($settings['grid_product_categories']) && $settings['grid_post_type'] == 'product') {
      $args['tax_query'] = array(
        'relation' => 'AND',
        array(
          'taxonomy' => 'product_cat',
          'field' => 'slug',
          'terms' => $settings['grid_product_categories'],
        ),
      );
    }
    if (!empty($settings['grid_items']) && intval($settings['grid_items']) == $settings['grid_items']) {
      $args['posts_per_page'] = $settings['grid_items'];
    }
    if (!empty($settings['grid_order_by'])) {
      $args['orderby'] = $settings['grid_order_by'];
    }
    if (!empty($settings['grid_pagination'])) {
      $paged         = get_query_var('paged');
      if (empty($paged)) {
        $paged         = get_query_var('page');
      }
      $args['paged'] = $paged;
    }
    $query = new \WP_Query($args);
    if ($query->have_posts()) {

      if (1 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-1.php');
      } elseif (2 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-2.php');
      } elseif (3 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-3.php');
      } elseif (4 == $grid_style) {
        include(__DIR__ . '/sidbar/layout-4.php');
      }
    } // end if; 

  }
}
