<?php

/**
 * Elementor App World Widget.
 *
 * @since 1.0.0
 */

class Aarticle_List extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'article-list';
    }

    public function get_title()
    {
        return __('article list', 'liosa');
    }

    public function get_icon()
    {
        return 'eicon-editor-list-ol';
    }

    public function get_categories()
    {
        return ['elementor-widget-be'];
    }



    private function grid_get_all_post_type_categories($post_type)
    {
        $options = array();

        if ($post_type == 'post') {
            $taxonomy = 'category';
        } else {
            $taxonomy = 'product_cat';
        }

        // Get categories for post type.
        $terms = get_terms(
            array(
                'taxonomy' => $taxonomy,
                'hide_empty' => false,
            )
        );

        foreach ($terms as $term) {
            $options[$term->slug] = $term->name;
        }

        return $options;
    }
    private function grid_get_all_post_types()
    {
        $options = array();
        $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

        $args = array(
            'public' => true,
        );

        foreach (get_post_types($args, 'objects') as $post_type) {

            if (!isset($post_type->name)) {
                continue;
            }

            if (!isset($post_type->label)) {
                continue;
            }

            if (in_array($post_type->name, $exclude) === true) {
                continue;
            }

            $options[$post_type->name] = $post_type->label;
        }

        return $options;
    }



        protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'liosa'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'grid_style',
            [
                'label' => __('Grid Style', 'liosa'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('Layout 1', 'liosa'),
                    '2' => esc_html__('Layout 2', 'liosa'),
                    '3' => esc_html__('Layout 3', 'liosa'),
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('Title', 'liosa'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'grid_style!' => '1',
                  ]
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'list_title',
            [
                'label' => __('Title', 'liosa'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('List Title', 'liosa'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'title_more',
            [
                'label' => __('Title More', 'liosa'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'number_post',
            [
                'label' => __('ID Category', 'liosa'),
                'description' => 'ID Category',
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '1',
            ]
        );
        $repeater->add_control(
            'bg_image',
            [
                'label' => __('Choose Image background', 'liosa'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'bg_image', // Actually its `image_size`
                'label' => __('Image Resolution', 'liosa'),
                'default' => 'large',
                'condition' => [
                    'bg_image[id]!' => '',
                ],
                'separator' => 'none',
            ]
        );
        $repeater->add_control(
            'image',
            [
                'label' => __('Choose Image', 'liosa'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'Iconlayoutvid_list',
            [
                'label' => __('Icon', 'liosa'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'grid_post_type',
            [
                'type'    => \Elementor\Controls_Manager::SELECT,
                'label'   => '<i class="fa fa-tag"></i> ' . __('Post Type', 'liosa'),
                'default' => 'post',
                'options' => $this->grid_get_all_post_types(),
            ]
        );
        $repeater->add_control(
            'grid_post_categories',
            [
                'type'    => \Elementor\Controls_Manager::SELECT,
                'label'   => '<i class="fa fa-folder"></i> ' . __('Category', 'liosa'),
                'options' => $this->grid_get_all_post_type_categories('post'),
                'condition' => [
                    'grid_post_type' => 'post',
                ],
            ]
        );
        $repeater->add_control(
            'grid_order_by',
            [
                'type'    => \Elementor\Controls_Manager::SELECT,
                'label'   => '<i class="fa fa-sort"></i> ' . __('Order by', 'liosa'),
                'default' => 'date',
                'options' => [
                    'date'          => __('Date', 'liosa'),
                    'title'         => __('Title', 'liosa'),
                    'modified'      => __('Modified date', 'liosa'),
                    'comment_count' => __('Comment count', 'liosa'),
                    'rand'          => __('Random', 'liosa'),
                ],
            ]
        );
        $repeater->add_control(
            'grid_content_price',
            [
                'label' => '<i class="fa fa-usd"></i> ' . __('Price', 'liosa'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition' => [
                    'section_grid.grid_post_type' => 'product',
                ],
            ]
        );
        $repeater->add_control(
            'grid_items',
            [
                'type'        => \Elementor\Controls_Manager::NUMBER,
                'label'       => '<i class="fa fa-th-large"></i> ' . __('Items', 'liosa'),
                'placeholder' => __('How many items?', 'liosa'),
                'default'     => 5,
            ]
        );
        $repeater->add_control(
            'show_more',
            [
                'label' => __('Show more', 'liosa'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'your-plugin'),
                'label_off' => __('Hide', 'your-plugin'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
            'website_link',
            [
                'label' => __('Link More', 'liosa'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'liosa'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'list',
            [
                'label' => __('Repeater List', 'liosa'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __('Title #1', 'liosa'),
                        'list_content' => __('Item content. Click the edit button to change this text.', 'liosa'),
                    ],
                    [
                        'list_title' => __('Title #2', 'liosa'),
                        'list_content' => __('Item content. Click the edit button to change this text.', 'liosa'),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'style_section_3',
            [
                'label' => __('General', 'liosa'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'head_background_full',
            [
              'label' => __('background color', 'liosa'),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => 'rgba(0, 0, 0, .04)',
              
              'selectors' => [
                '{{WRAPPER}} .Graders-content .solid-home,.widget_box_ch_list,.widget_box_ch_list' => 'background-color: {{VALUE}}!important;',
              ],
            ]
          );
          $this->add_control(
            'border_radius_full',
            [
              'label' => __( 'border radius', 'liosa' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px', '%' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
                ],
                '%' => [
                  'min' => 0,
                  'max' => 100,
                ],
              ],
              'default' => [
                'unit' => 'px',
                'size' => 0,
              ],
              'selectors' => [
               '{{WRAPPER}} .Graders-content .solid-home,.widget_box_ch_list' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
             ],
            ]
          );
        $this->end_controls_section();
        $this->start_controls_section(
            'widget_header',
            [
              'label' => __('header', 'liosa'),
              'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
          );
          $this->add_control(
            'box_title',
            [
              'label' => __('title', 'liosa'),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#fff',
              
              'selectors' => [
                '{{WRAPPER}} .cat-card .card-title a,.widget_box_ch_list .section-heading,.section-heading span, .section-heading_3 span' => 'color: {{VALUE}}!important;',
              ],
            ]
          );
          $this->add_control(
            'head_background',
            [
              'label' => __('background color', 'liosa'),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => 'rgba(0, 0, 0, .04)',
              
              'selectors' => [
                '{{WRAPPER}} .widget_box_ch_list .section-heading' => 'background-color: {{VALUE}}!important;',
              ],
            ]
          );
          $this->add_control(
            'border_Color',
            [
                'label' => __('border Color', 'liosa'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .section-heading::after,.section-heading_3' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .section-heading_3' => 'border-color: {{VALUE}}!important',
                ],
                'default' => '#9e2358',
                'condition' => [
                    'grid_style!' => '1',
                  ]
            ]
        );
           $this->add_control(
            'border_radius_headmore',
            [
              'label' => __( 'border radius', 'liosa' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px', '%' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
                ],
                '%' => [
                  'min' => 0,
                  'max' => 100,
                ],
              ],
              'default' => [
                'unit' => 'px',
                'size' => 0,
              ],
              'selectors' => [
               '{{WRAPPER}} .widget_box_ch_list .section-heading' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
             ],
            ]
          );
          $this->add_control(
            'Iconlayoutvid',
            [
                'label' => __('Icon', 'liosa'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [
                    'grid_style!' => '1',
                  ]
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'style_section_box',
            [
                'label' => __('box', 'liosa'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_more_Color',
            [
                'label' => __('title more', 'liosa'),
                'type' => \Elementor\Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .cat-card footer a,.title_more_lis3,.title_more_lis2' => 'color: {{VALUE}}',
                ],
                'default' => '#212121',
            ]
        );
        $this->add_control(
            'border_radius_box',
            [
              'label' => __( 'border radius', 'liosa' ),
              'type' => \Elementor\Controls_Manager::SLIDER,
              'size_units' => [ 'px', '%' ],
              'range' => [
                'px' => [
                  'min' => 0,
                  'max' => 100,
                  'step' => 1,
                ],
                '%' => [
                  'min' => 0,
                  'max' => 100,
                ],
              ],
              'default' => [
                'unit' => 'px',
                'size' => 5,
              ],
              'selectors' => [
               '{{WRAPPER}} .cat-card.verticalarea,.cat-card .card-thumb,.article_post3 .article3_list_posts li .featured a, .widget_box_ch_list .listing_posts .featured a' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
             ],
            ]
          );
        $this->end_controls_section();
    }



    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $grid_style = $settings['grid_style'];
        if (1 == $grid_style) {

            include(__DIR__ . '/list/layout-1.php');
        } elseif (2 == $grid_style) {

            include(__DIR__ . '/list/layout-2.php');
        } elseif (3 == $grid_style) {

            include(__DIR__ . '/list/layout-3.php');
        }
        wp_reset_postdata();
    }
}
