<?php

/**
 * Elementor Box Content Responsive Widget.
 *
 */

class Article_2 extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'article-2';
  }

  public function get_title()
  {
    return __('Article 2', 'liosa');
  }

  public function get_icon()
  {
    return 'eicon-image-box';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }

  private function grid_get_all_post_type_categories($post_type)
  {
    $options = array();

    if ($post_type == 'post') {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }



      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls()
  {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Content', 'liosa'),
      ]
    );
    $this->add_control(
      'title',
      [
        'label' => __('Title', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title_more',
      [
        'label' => __('Title More', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    // Post type.
    $this->add_control(
      'grid_post_type',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-tag"></i> ' . __('Post Type', 'liosa'),
        'default' => 'post',
        'options' => $this->grid_get_all_post_types(),
      ]
    );
    $this->add_control(
      'grid_items',
      [
        'type'        => \Elementor\Controls_Manager::NUMBER,
        'label'       => '<i class="fa fa-th-large"></i> ' . __('Items', 'liosa'),
        'placeholder' => __('How many items?', 'liosa'),
        'default'     => 4,
      ]
    );

    // Post categories.
    $this->add_control(
      'grid_post_categories',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-folder"></i> ' . __('Category', 'liosa'),
        'options' => $this->grid_get_all_post_type_categories('post'),
        'condition' => [
          'grid_post_type' => 'post',
        ],
      ]
    );
    $this->add_control(
      'show_more',
      [
        'label' => __('Show more', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'website_link',
      [
        'label' => __('Link More', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'grid_pagination',
      [
        'label' => '<i class="fa fa-arrow-circle-right"></i> ' . __('Pagination', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => '',
      ]
    );
    // Order by.
    $this->add_control(
      'grid_order_by',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-sort"></i> ' . __('Order by', 'liosa'),
        'default' => 'date',
        'options' => [
          'date'          => __('Date', 'liosa'),
          'title'         => __('Title', 'liosa'),
          'modified'      => __('Modified date', 'liosa'),
          'comment_count' => __('Comment count', 'liosa'),
          'rand'          => __('Random', 'liosa'),
        ],
      ]
    );

    // Price.
    $this->add_control(
      'grid_content_price',
      [
        'label' => '<i class="fa fa-usd"></i> ' . __('Price', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes',
        'condition' => [
          'section_grid.grid_post_type' => 'product',
        ],
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'section_query',
      [
        'label' => __('icon', 'liosa'),
      ]
    );
    $this->add_control(
      'icon_1',
      [
        'label' => __('Icons one', 'liosa'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-star',
          'library' => 'solid',
        ],
      ]
    );
    $this->add_control(
      'icon_2',
      [
        'label' => __('Icons two', 'liosa'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-star',
          'library' => 'solid',
        ],
      ]
    );
    $this->add_control(
      'icon_3',
      [
        'label' => __('Icons three', 'liosa'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-star',
          'library' => 'solid',
        ],
      ]
    );
    $this->add_control(
      'icon_4',
      [
        'label' => __('Icons four', 'liosa'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
          'value' => 'fas fa-star',
          'library' => 'solid',
        ],
      ]
    );
    $this->add_control(
      'title_color_1',
      [
        'label' => __('Icons Color one', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_2',
      [
        'label' => __('Icons Color two', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_3',
      [
        'label' => __('Icons Color three', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_4',
      [
        'label' => __('Icons Color four', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'show_title_1',
      [
        'label' => __('Show Icons one', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'show_title_2',
      [
        'label' => __('Show Icons two', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'show_title_3',
      [
        'label' => __('Show Icons three', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'show_title_4',
      [
        'label' => __('Show Icons four', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->end_controls_section();
    $this->start_controls_section(
      'section_style',
      [
        'label' => __( 'Style', 'liosa' ),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
     'background',
     [
       'label' => __('background color', 'liosa'),
       'type' => \Elementor\Controls_Manager::COLOR,
       'default' => '#fff',
       
       'selectors' => [
         '{{WRAPPER}} .article-2' => 'background-color: {{VALUE}}!important;',
       ],
     ]
   );
   $this->add_control(
     'box_title',
     [
       'label' => __('title', 'liosa'),
       'type' => \Elementor\Controls_Manager::COLOR,
       'default' => '#535353',
       
       'selectors' => [
         '{{WRAPPER}} .article-2 .Survey-title' => 'color: {{VALUE}}!important;',
       ],
     ]
   );
   $this->add_control(
     'box_title_more',
     [
       'label' => __('Title More', 'liosa'),
       'type' => \Elementor\Controls_Manager::COLOR,
       'default' => '#eee',
       
       'selectors' => [
         '{{WRAPPER}} .article-2 .Survey-bt-mor' => 'background-color: {{VALUE}}!important;',
       ],
     ]
   );
   $this->add_control(
     'box_title_more_text',
     [
       'label' => __('Title More text', 'liosa'),
       'type' => \Elementor\Controls_Manager::COLOR,
       'default' => '#535353',
       
       'selectors' => [
         '{{WRAPPER}} .article-2 .Survey-bt-mor' => 'color: {{VALUE}}!important;',
       ],
     ]
   );
    $this->add_control(
     'border_radius_article_blog_1',
     [
       'label' => __( 'border radius', 'liosa' ),
       'type' => \Elementor\Controls_Manager::SLIDER,
       'size_units' => [ 'px', '%' ],
       'range' => [
         'px' => [
           'min' => 0,
           'max' => 100,
           'step' => 1,
         ],
         '%' => [
           'min' => 0,
           'max' => 100,
         ],
       ],
       'default' => [
         'unit' => 'px',
         'size' => 5,
       ],
       'selectors' => [
        '{{WRAPPER}} .article-2' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
      ],
     ]
   );
    $this->end_controls_section();
    $this->start_controls_section(
     'section_style_box',
     [
       'label' => __( 'box', 'liosa' ),
       'tab' => \Elementor\Controls_Manager::TAB_STYLE,
     ]
   );
   $this->add_control(
     'border_radius_article',
     [
       'label' => __( 'border radius', 'liosa' ),
       'type' => \Elementor\Controls_Manager::SLIDER,
       'size_units' => [ 'px', '%' ],
       'range' => [
         'px' => [
           'min' => 0,
           'max' => 100,
           'step' => 1,
         ],
         '%' => [
           'min' => 0,
           'max' => 100,
         ],
       ],
       'default' => [
         'unit' => 'px',
         'size' => 5,
       ],
       'selectors' => [
         '{{WRAPPER}} .article-2 .card-home,.article-2 .card-head' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
       ],
     ]
   );
    $this->end_controls_section();
    $this->start_controls_section(
      'style_section_1',
      [
        'label' => __('Page counter', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'counter_active',
      [
        'label' => __('background color active', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fb3449',
        
        'selectors' => [
          '{{WRAPPER}} .article-2 .pagenumbers span.current, .pagenumbers span:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'counter_text_active',
      [
        'label' => __('text active', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
        
        'selectors' => [
          '{{WRAPPER}} .article-2 .pagenumbers span.current, .pagenumbers span:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'counter',
      [
        'label' => __('background color', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#fff',
        
        'selectors' => [
          '{{WRAPPER}} .article-2 .pagenumbers a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'counter_text',
      [
        'label' => __('text', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'default' => '#616161',
        
        'selectors' => [
          '{{WRAPPER}} .article-2 .pagenumbers a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'border_radius_numbe',
      [
        'label' => __( 'border radius', 'liosa' ),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 5,
        ],
        'selectors' => [
          '{{WRAPPER}} .article-2 .pagenumbers a,.article-2 .pagenumbers span.current' => 'border-radius: {{SIZE}}{{UNIT}}!important;',
        ],
      ]
    );
    $this->end_controls_section();
   }


  protected function render()
  {
    $settings = $this->get_settings();
    $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
    $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';
?>
    <div class="container">
      <section class="background_box_article article-2 col-12">
        <header class="col title-five">
          <a class="inner-card" href="<?php the_permalink(); ?>">
            <h4 class="Survey-title"><?php echo $settings['title']; ?></h4>
            <?php
            if ('yes' === $settings['show_more']) {
              echo '<a class="Survey-bt-mor" href="' . $settings['website_link']['url'] . '"' . $target . $nofollow . '>';
              echo $settings['title_more'];
              ''; ?>
          </a>
        <?php } ?>
        </a>
        </header>
        <?php
        $args = array();
        $args['post_status'] = 'publish';
        $args['ignore_sticky_posts'] = 1;
        if (!empty($settings['grid_post_type']) && post_type_exists($settings['grid_post_type'])) {
          $args['post_type'] = $settings['grid_post_type'];
        }
        if (!empty($settings['grid_post_categories']) && $settings['grid_post_type'] == 'post') {
          $args['category_name'] = $settings['grid_post_categories'];
        }
        if (!empty($settings['grid_product_categories']) && $settings['grid_post_type'] == 'product') {
          $args['tax_query'] = array(
            'relation' => 'AND',
            array(
              'taxonomy' => 'product_cat',
              'field' => 'slug',
              'terms' => $settings['grid_product_categories'],
            ),
          );
        }
        if (!empty($settings['grid_items']) && intval($settings['grid_items']) == $settings['grid_items']) {
          $args['posts_per_page'] = $settings['grid_items'];
        }
        if (!empty($settings['grid_order_by'])) {
          $args['orderby'] = $settings['grid_order_by'];
        }
        if (!empty($settings['grid_pagination'])) {
          $paged         = get_query_var('paged');
          if (empty($paged)) {
            $paged         = get_query_var('page');
          }
          $args['paged'] = $paged;
        }
        $query = new \WP_Query($args);
        if ($query->have_posts()) {
          while ($query->have_posts()) {
            $query->the_post();
        ?>
            <div class="col-12 col-xl-3 col-md-4 col-sm-6 col-xs-12 right">
              <div class="card-home card-chart" data-count="11">
                <div class="card-head card-header-rose" data-header-animation="true">
                  <?php
                  if (has_post_thumbnail()) {
                    the_post_thumbnail(array(300, 300), array('alt' => '' . get_the_title(), 'title' => '' . get_the_title() . ''));
                  } else { ?>
                    <img src="<?php print(get_template_directory_uri()); ?>/assets/images/thumb.gif" width="60" height="60" alt="<?php _e('Image not found', 'liosa'); ?>" title="<?php _e('Image not found', 'liosa'); ?>">
                  <?php } ?>
                </div>
                <div class="card-body">
                  <div class="card-actions">
                    <?php
                    if ('yes' === $settings['show_title_1']) { ?> <a target="_blank" href="<?php echo __get_meta('__application0'); ?>" style="color: <?php echo $settings['title_color_1'] ?>"><?php \Elementor\Icons_Manager::render_icon($settings['icon_1'], ['aria-hidden' => 'true']); ?></a> <?php }
                                                                                                                                                                                                                                                                                                  if ('yes' === $settings['show_title_2']) { ?> <a target="_blank" href="<?php echo __get_meta('__application1'); ?>" style="color: <?php echo $settings['title_color_2'] ?>"><?php \Elementor\Icons_Manager::render_icon($settings['icon_2'], ['aria-hidden' => 'true']); ?></a> <?php }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if ('yes' === $settings['show_title_3']) { ?> <a target="_blank" href="<?php echo __get_meta('__application2'); ?>" style="color: <?php echo $settings['title_color_3'] ?>"><?php \Elementor\Icons_Manager::render_icon($settings['icon_3'], ['aria-hidden' => 'true']); ?></a> <?php }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              if ('yes' === $settings['show_title_4']) { ?> <a target="_blank" href="<?php echo __get_meta('__application3'); ?>" style="color: <?php echo $settings['title_color_4'] ?>"><?php \Elementor\Icons_Manager::render_icon($settings['icon_4'], ['aria-hidden' => 'true']); ?></a> <?php }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ?>
                  </div>
                  <h4 class="card-title-h">
                    <a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a>
                  </h4>
                </div>
                <div class="card-footer">
                  <div class="stats">
                    <?php
                    if (get_the_modified_date() != get_the_date()) {
                      echo 'اخرین بروز  رسانی در' . get_the_modified_date('j F Y ساعت H:i');
                    }
                    ?>
                  </div>
                </div>
              </div>
            </div>
          <?php
          }
          if (!empty($settings['grid_pagination'])) {
          ?>
            <div class="pagination root" style="width: 100%;">
              <?php
              $big = 999999999;
              $totalpages = $query->max_num_pages;
              $current = max(1, $paged);
              $paginate_args = array(
                'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
                'format'    => '?paged=%#%',
                'current'   => $current,
                'total'     => $totalpages,
                'show_all'  => false,
                'end_size'  => 1,
                'mid_size'  => 3,
                'prev_next' => true,
                'prev_text'          => __('<i class="fa fa-chevron-right" aria-hidden="true"></i>', 'liosa'),
                'next_text'          => __('<i class="fa fa-chevron-left" aria-hidden="true"></i>', 'liosa'),
                'screen_reader_text' => __('A', 'liosa')
              );
              $pagination = paginate_links($paginate_args);
              ?>
              <nav class="pagenumbers">
                <?php echo $pagination; ?>
              </nav>
            </div>
        <?php
          }
        } // end if; 
        ?>
      </section>
    </div>
<?php
  }
}
