<?php get_header();
get_template_part('themeplat/header/select-nav', 'navbar'); ?>
<div id="content" class="narrowcolumn">

    <?php
    $curauth = (isset($_GET['author_name'])) ? get_user_by('slug', $author_name) : get_userdata(intval($author));
    $twitter = get_the_author_meta('twitter', $post->post_author);
    $facebook = get_the_author_meta('facebook', $post->post_author);
    $instagram = get_the_author_meta('instagram', $post->post_author);
    $linkedin = get_the_author_meta('linkedin', $post->post_author);
    $pinterest = get_the_author_meta('pinterest', $post->post_author);
    $dribbble = get_the_author_meta('dribbble', $post->post_author);
    $googleplus = get_the_author_meta('googleplus', $post->post_author);

    ?>
    <div class="container Graders-content author_profile guttered">
        <div class="author_digibe">
            <div class="breadcrumb_DB">
                <?php get_breadcrumb(); ?>
            </div>
            <div class="media-header">
                <div class="row">
                    <div class="col-7">
                        <a class="avatar tiny" href="<?php the_permalink(); ?>">
                            <?php echo get_avatar(get_the_author_meta('user_email'), '120', ''); ?>
                        </a>
                        <span class="media-header__content">
                            <h1 class="title"><?php echo get_the_author(); ?></h1>
                        </span>
                    </div>
                    <div class="col-5">
                        <span class="avatar_user_url">
                            <a href="<?php echo $curauth->user_url; ?>"><i class="fa fa-external-link" aria-hidden="true"></i> وب سایت</a>
                        </span>
                    </div>
                </div>
            </div>
            <div class="avatar_user_description">
                <?php echo $curauth->user_description; ?>
            </div>
            <div class="media-header_footer">
                <div class="row">
                    <div class="col-6">

                        <ul class="soch_avatar_user">
                            <li>
                                <?php echo '<a href="' . $facebook . '" rel="nofollow" target="_blank"><i class="fa fa-facebook" aria-hidden="true"></i></a>'; ?>
                            </li>
                            <li>
                                <?php echo '<a href="https://twitter.com/' . $twitter . '" rel="nofollow" target="_blank"><i class="fa-brands fa-x-twitter" aria-hidden="true"></i></a>'; ?>
                            </li>
                            <li>
                                <?php echo '<a href="https://instagram.com/' . $instagram . '" rel="nofollow" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a>'; ?>
                            </li>
                            <li>
                                <?php echo '<a href="https://linkedin.com/' . $linkedin . '" rel="nofollow" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a>'; ?>
                            </li>
                            <li>
                                <?php echo '<a href="https://pinterest.com/' . $pinterest . '" rel="nofollow" target="_blank"><i class="fa fa-pinterest-p" aria-hidden="true"></i></a>'; ?>
                            </li>
                            <li>
                                <?php echo '<a href="https://dribbble.com/' . $dribbble . '" rel="nofollow" target="_blank"><i class="fa fa-dribbble" aria-hidden="true"></i></a>'; ?>
                            </li>
                            <li>
                                <?php echo '<a href="https://plus.google.com/' . $googleplus . '" rel="nofollow" target="_blank"><i class="fa fa-google" aria-hidden="true"></i></a>'; ?>
                            </li>
                        </ul>
                    </div>
                    <div class="col-6">
                        <p class="avatar_number_format">
                        <ul class="soch_avatar_user" style="float: left;">
                            <li><?php echo number_format_i18n(get_the_author_posts()); ?> نوشته </li>
                            <ul>
                                </p>
                    </div>
                </div>
            </div>
        </div>
        <article class="root">
            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                    <div class="content_item">
                        <div class="content_item_time">
                            <div class="content_item__time">
                                <div class="content_item__time">
                                    <?php $archive_year  = get_the_time('Y'); ?>
                                    <?php $archive_month = get_the_time('m'); ?>
                                    <a href="<?php echo get_month_link($archive_year, $archive_month); ?>">
                                        <span class="content_item__icon"><i class="fal fa-clock"></i></span>
                                        <span class="content_item__timeago">
                                            <time><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?></time>
                                        </span>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="content_item__cart">
                            <article class="content_item__cart__link">
                                <div class="content_item__cart__media">
                                    <a href="<?php the_permalink(); ?>">
                                        <figure class="content_item__cart__media__image">
                                            <?php
                                            if (has_post_thumbnail()) {
                                                the_post_thumbnail(array(300, 300), array('alt' => '' . get_the_title(), 'title' => '' . get_the_title() . ''));
                                            } else { ?>
                                                <img src="<?php bloginfo('template_url'); ?>/assets/images/thumb.gif" width="60" height="60" alt="<?php _e('Image not found', 'liosa'); ?>" title="<?php _e('Image not found', 'liosa'); ?>">
                                            <?php } ?>
                                        </figure>
                                    </a>
                                </div>
                                <div class="content_item__cart__detail">
                                    <div class="content_item__cart__detail__container">
                                        <div class="content_item__cart__detail-top">
                                            <h5 class="content_item__cart__detail__category">
                                                <?php the_category(); ?>
                                            </h5>
                                            <span class="content_item__cart__detail__time">
                                                <?php $archive_year  = get_the_time('Y'); ?>
                                                <?php $archive_month = get_the_time('m'); ?>
                                                <a href="<?php echo get_month_link($archive_year, $archive_month); ?>">
                                                    <time><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?></time>
                                                </a>
                                            </span>
                                        </div>
                                        <h3 class="content_item__cart__detail__title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h3>
                                        <div class="content_item__cart__detail__excerpt">
                                            <div class="desc">
                                                <?php echo '<p class="text text_1">' . get_the_excerpt() . '</p>'; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        </div>
                    </div>
                <?php endwhile;
            else : ?>
                <p><?php _e('Sorry, no posts matched your criteria.', 'liosa'); ?></p>
            <?php endif; ?>
            <?php get_template_part('themeplat/content/pagenumbers', 'pagenumbers'); ?>
        </article>
    </div>
</div>
<?php get_footer(); ?>